"use strict"
{

	const C3 = globalThis.C3;
	C3.Behaviors.Overboy_JSONb.Exps = {
		//==============================================================================

		CurLoopindex() {
			return this._curLoopindex
		},

		o(key) {
			return Object.values(arguments).join(".")
		},
		Get(path) {
			return this._GetSafeValue(Object.values(arguments).join("."))
		},
		At(path) {
			return this._GetSafeValue(Object.values(arguments).join("."))
		},
		AtPath(str) {
			return this._GetSafeValue(str)
		},
		At_Str(str) {
			return this._GetStringValue(Object.values(arguments).join("."))
		},
		AtPath_Str(str) {
			return this._GetStringValue(str)
		},

		MapPath() {
			return this.mapPath
		},

		MapKey() {
			return this.mapKey
		},

		MapValue() {
			return this.mapValue
		},

		MapFunctionName() {
			return this.mapFnName
		},

		ParamCount() {
			if (this._Array_IsEmpty(this.parameters)) {
				return 0
			} else {
				const latestIndex = this._Array_GetLastIndex(this.parameters)
				const paramLen = this.parameters[latestIndex].length

				return paramLen
			}
		},

		Param(index) {
			if (this._Array_IsEmpty(this.parameters)) {
				return 0
			} else {
				const latestIndex = this._Array_GetLastIndex(this.parameters)
				const paramRefer = this.parameters[latestIndex]

				if (this._Array_IsEmpty(paramRefer)) {
					return 0
				} else {
					const paramLen = paramRefer.length

					if (index >= 0 && index < paramLen) {
						const elemVal = this.parameters[latestIndex][index]

						if (typeof elemVal === "undefined") {
							return 0
						} else {
							return elemVal
						}
					} else {
						return 0
					}
				}
			}
		},

		KeysAt(str) {
			const obj = this._GetValue(Object.values(arguments).join("."))
			//if (Array.isArray(value)) return value.length
			if (typeof obj === "object" && obj !== null) {
				let keys = Object.keys(obj)
				return JSON.stringify(keys)
			} else return ""
		},

		KeysAtPath(str) {
			const obj = this._GetValue(str)
			//if (Array.isArray(value)) return value.length
			if (typeof obj === "object" && obj !== null) {
				let keys = Object.keys(obj)
				return JSON.stringify(keys)
			} else return ""
		},

		EntriesAt(str) {
			const obj = this._GetValue(Object.values(arguments).join("."))
			//if (Array.isArray(value)) return value.length
			if (typeof obj === "object" && obj !== null) {
				let entries = Object.entries(obj)
				return JSON.stringify(entries)
			} else return ""
		},

		EntriesAtPath(str) {
			const obj = this._GetValue(str)
			//if (Array.isArray(value)) return value.length
			if (typeof obj === "object" && obj !== null) {
				let entries = Object.entries(obj)
				return JSON.stringify(entries)
			} else return ""
		},

		GetRandomKey(str) {
			const obj = this._GetValue(str)
			if (typeof obj === "object" && obj !== null) {
				let keys = Object.keys(obj)
				return keys[Math.floor(Math.random() * keys.length)]
			} else if (Array.isArray(obj)) {
				return Math.floor(Math.random() * obj.length)
			} else return ""
		},

		//==============================================================================

		//Basic Features

		ToCompactString() {
			try {
				return JSON.stringify(this._data)
			} catch (err) {
				return ""
			}
		},
		ToBeautifiedString() {
			//console.log("ToBeautifiedString: " + this._data)
			try {
				return JSON.stringify(this._data, null, 4)
			} catch (err) {
				return ""
			}
		},

		GetAsCompactString(str) {
			const value = this._GetValue(str)
			return JSON.stringify(value)
		},
		GetAsBeautifiedString(str) {
			const value = this._GetValue(str)
			return JSON.stringify(value, null, 4)
		},
		Front(str) {
			const parent = this._GetValue(str)
			if (Array.isArray(parent)) {
				const value = parent[0]
				return this._ToSafeValue(value)
			} else return -1
		},
		Back(str) {
			const parent = this._GetValue(str)
			if (Array.isArray(parent)) {
				const value = parent.at(-1)
				return this._ToSafeValue(value)
			} else return -1
		},
		Type(str) {
			return this._GetTypeOf(str)
		},
		ArraySize(str) {
			const value = this._GetValue(str)
			if (Array.isArray(value)) return value.length
			else return -1
		},
		Path() {
			return this._path.map((seg) => seg.replace(/\./g, "\\.")).join(".")
		},
		CurKey() {
			return this._currentKey
		},
		CurValue() {
			return this._ToSafeValue(this._currentValue)
		},
		CurType() {
			return this._JSONTypeOf(this._currentValue)
		}
	}
}
