"use strict"
{

	const C3 = globalThis.C3;
	const JSON_TYPES = ["null", "boolean", "number", "string", "object", "array"]
	C3.Behaviors.Overboy_JSONb.Cnds = {
		//==============================================================================

		//Better Features (Sorting and Mapping)

		OnMappingFn(name) {
			return this.mapFnName === name
		},

		CompareParamVal(paramIndex, compareBy, paramValue) {
			//Check if have parameters
			if (this._Array_IsEmpty(this.parameters)) {
				return false
			}

			// Get Parameters List Latest
			const latestIndex = this._Array_GetLastIndex(this.parameters)

			//Define Reference
			const paramRefer = this.parameters[latestIndex]
			const paramLen = paramRefer.length

			if (paramIndex >= 0 && paramIndex < paramLen) {
				//Define Compare Parts
				const compareValue = paramRefer[paramIndex]

				//Do Comparison
				return C3.compare(compareValue, compareBy, paramValue)
			} else {
				return false
			}
		},

		ForEachOrderedByKeyValue(str, type, subKey, sortMode_) {
			//console.log("ForEachOrderedByKeyValue", str, type, subKey, sortMode_)
			if (type === 0) {
				//console.log("For Each Ordered By Key")
				this._ForEach(str, this._SortByKey(str, subKey, sortMode_))
			} else {
				//console.log("For Each Ordered By Value")
				this._ForEach(str, this._SortByValue(str, subKey, sortMode_))
			}
		},

		ForEachOrderedByKey(str, subKey, sortMode_) {
			this._ForEach(str, this._SortByKey(str, subKey, sortMode_))
		},

		ForEachOrderedByValue(str, subKey, sortMode_) {
			this._ForEach(str, this._SortByValue(str, subKey, sortMode_))
		},

		ForEachOrderedByMapping(str, fnName, params, sortMode_) {
			this._ForEach(str, this._SortByMappingFunction(str, fnName, params, sortMode_))
		},

		ForEach(str) {
			this._ForEach(str)
		},

		HasKeyAll(path, keys) {
			for (const key of keys.split(" ")) if (!this._HasKey(key)) return false
			return true
		},

		HasKeyAny(path, keys) {
			for (const key of keys.split(" ")) if (this._HasKey(key)) return true
			return false
		},

		HasKeyIn(key, path) {
			if (path === "") return this._HasKey(key)
			return this._HasKey(path + "." + key)
		},

		IsEmpty(path) {
			const val = this._GetValue(path)
			const typeOf = this._JSONTypeOf(val)

			//console.log("Is empty", val, typeOf)

			if (typeOf === "object") return Object.keys(val).length === 0
			else if (typeOf === "array") return val.length === 0
			else return false
		},

		//==============================================================================

		//Basic Features
		HasKey(str) {
			return this._HasKey(str)
		},
		CompareType(str, typeIndex) {
			return this._GetTypeOf(str) === JSON_TYPES[typeIndex]
		},
		CompareValue(str, cmp, value) {
			return C3.compare(this._GetSafeValue(str), cmp, value)
		},
		IsBooleanSet(str) {
			return this._GetValue(str) === true
		},
		OnParseError() {
			return true
		}
	}
}
