"use strict"
const SDK = globalThis.SDK;
{
	const BEHAVIOR_ID = "Overboy_JSONb"
	const BEHAVIOR_CATEGORY = "general"
	const BEHAVIOR_CLASS = (SDK.Behaviors.Overboy_JSONb = class Overboy_JSONb extends SDK.IBehaviorBase {
		constructor() {
			super(BEHAVIOR_ID)
			SDK.Lang.PushContext("behaviors." + BEHAVIOR_ID.toLowerCase())

			this._info.SetName(lang(".name"))
			this._info.SetDescription(lang(".description"))
			this._info.SetCategory(BEHAVIOR_CATEGORY)
			this._info.SetAuthor("Overboy")
			this._info.SetHelpUrl(lang(".help-url"))
			this._info.SetIsOnlyOneAllowed(false)
			this._info.SetC3RuntimeScripts(["c3runtime/behavior.js",
				"c3runtime/instance.js",
				"c3runtime/conditions.js",
				"c3runtime/actions.js",
				"c3runtime/expressions.js"])

			SDK.Lang.PushContext(".properties")
			SDK.Lang.PopContext() // .properties
			SDK.Lang.PopContext()
		}
	})
	BEHAVIOR_CLASS.Register(BEHAVIOR_ID, BEHAVIOR_CLASS)
}
