"use strict"
{
	const C3 = globalThis.C3
	C3.Behaviors.Overboy_JSONb.Instance = class Overboy_JSONbInstance extends globalThis.ISDKBehaviorInstanceBase {
		constructor() {
			super()

			this._valueCache = [null, null]
			this._locationCache = [null, null]
			this._data = {}
			this._path = []
			this._currentKey = ""
			this._currentValue = 0
			this._curLoopindex = 0
			this._stoploop = false

			//mapping
			this.mappingResult = 0
			this.mapFnName = ""
			this.mapPath = ""
			this.mapKey = ""
			this.mapValue = ""
			this.parameters = []
		}

		//==============================================================================
		_CallMapFunction(fnName, params, keyPath) {
			this.mapFnName = fnName
			this.mappingResult = 0
			this.mapPath = keyPath
			this.mapValue = this._GetValue(keyPath)
			const keys = keyPath.split(".")
			this.mapKey = keys[keys.length - 1]

			var array = params.split("|")
			this.parameters.push(array)

			this._trigger(C3.Behaviors.Overboy_JSONb.Cnds.OnMappingFn, this)
			//this.Fast_trigger(C3.Behaviors.Overboy_JSONb.Cnds.OnMappingFn,this,fnName);
			this.parameters.pop()

			console.log("CallMapFunction (" + fnName + ") : " + keyPath + " mapping = " + this.mappingResult)
			return this.mappingResult
		}
		//==============================================================================
		_InvalidateValueCache() {
			this._valueCache[0] = null
			this._valueCache[1] = null
		}
		_HasValueCache(arr, isMutate) {
			const cacheArr = this._valueCache[0]
			if (arr === null || cacheArr === null) return false
			if (cacheArr === arr || C3.arraysEqual(cacheArr, arr)) return true
			if (isMutate && cacheArr.length > 0) {
				for (let i = 0, len = Math.min(arr.length, cacheArr.length); i < len; ++i) if (arr[i] !== cacheArr[i]) return false
				return true
			} else return false
		}
		_GetValueCache() {
			return this._valueCache[1]
		}
		_UpdateValueCache(arr, value) {
			this._valueCache[0] = arr
			this._valueCache[1] = value
		}
		_InvalidateLocationCache() {
			this._locationCache[0] = null
			this._locationCache[1] = null
		}
		_HasLocationCache(str) {
			return this._locationCache[0] === str
		}
		_GetLocationCache() {
			return this._locationCache[1]
		}
		_UpdateLocationCache(str, value) {
			this._locationCache[0] = str
			this._locationCache[1] = value
		}
		_SetData(obj) {
			this._data = obj
			this._InvalidateValueCache()
			this._SetPath("")
		}
		_GetData() {
			return this._data
		}
		_SetPath(str) {
			this._path = this._ParsePathUnsafe(str)
			this._InvalidateLocationCache()
		}
		_ParsePath(str) {
			return C3.cloneArray(this._ParsePathUnsafe(str))
		}
		_ParsePathUnsafe(str) {
			const buffer = []
			let escaped = false
			let parts
			if (this._HasLocationCache(str)) return this._GetLocationCache()
			if (str[0] === ".") {
				parts = C3.cloneArray(this._path)
				str = str.slice(1)
			} else parts = []
			for (const c of str)
				if (escaped) {
					buffer.push(c)
					escaped = false
				} else if (c === "\\") escaped = true
				else if (c === ".") {
					parts.push(buffer.join(""))
					C3.clearArray(buffer)
				} else buffer.push(c)
			if (buffer.length !== 0) parts.push(buffer.join(""))
			this._UpdateLocationCache(str, parts)
			return parts
		}
		_GetValueAtFullPath(path, lazyCreate) {
			if (this._HasValueCache(path, false)) return this._GetValueCache()
			let result = this._data
			for (const part of path)
				if (Array.isArray(result)) {
					const index = parseInt(part, 10)
					if (index < 0 || index >= result.length || !isFinite(index)) {
						result = null
						break
					}
					result = result[index]
				} else if (typeof result === "object" && result !== null)
					if (result.hasOwnProperty(part)) result = result[part]
					else if (lazyCreate) {
						const o = {}
						result[part] = o
						result = o
					} else {
						result = null
						break
					}
				else {
					result = null
					break
				}
			this._UpdateValueCache(path, result)
			return result
		}
		_GetValue(str) {
			const path = this._ParsePath(str)
			if (!path.length) return this._data
			const key = path.pop()
			const obj = this._GetValueAtFullPath(path, false)
			if (Array.isArray(obj)) {
				const index = parseInt(key, 10)
				return index >= 0 && index < obj.length ? obj[index] : null
			} else if (typeof obj === "object" && obj !== null) {
				return obj.hasOwnProperty(key) ? obj[key] : null
			} else return null
		}

		_GetValue_CanCreateArray(str) {
			const path = this._ParsePath(str)
			if (!path.length) return this._data
			//console.log("path.length", path.length)
			const key = path.pop()
			const obj = this._GetValueAtFullPath(path, false)
			if (Array.isArray(obj)) {
				//console.log("Is Array")
				const index = parseInt(key, 10)
				return index >= 0 && index < obj.length ? obj[index] : null
			} else if (typeof obj === "object" && obj !== null) {
				if (obj.hasOwnProperty(key)) {
					//console.log("Is Object")
					return obj[key]
				} else {
					//console.log("Creating array 1")
					let newArray = []
					C3.extendArray(newArray, 0, 0)
					this._SetValue(str, newArray)
					return newArray
				}
			} else {
				//Create array if needed
				//console.log("Creating array 2")
				let newArray = []
				C3.extendArray(newArray, 0, 0)
				this._SetValue(str, newArray)
				return newArray
			}
		}

		_JSONTypeOf(val) {
			if (val === null) return "null"
			else if (Array.isArray(val)) return "array"
			else return typeof val
		}
		_GetTypeOf(str) {
			const val = this._GetValue(str)
			return this._JSONTypeOf(val)
		}
		_ToSafeValue(value) {
			const type = typeof value
			if (type === "number" || type === "string") return value
			else if (type === "boolean") return value ? 1 : 0
			else return 0
		}
		_GetSafeValue(str) {
			return this._ToSafeValue(this._GetValue(str))
		}

		_GetSafeValueSort(str) {
			const value = this._GetValue(str)
			const type = typeof value
			if (type === "number" || type === "string") return value
			else if (type === "boolean") return value ? 1 : 0
			else return Infinity
		}

		_GetStringValue(str) {
			const val = this._GetValue(str)
			const type = typeof val
			if (type === "number") return val.toString()
			else if (type === "string") return val
			else if (type === "boolean") return val ? "True" : "False"
			else return "Object"
		}

		_HasKey(str) {
			const path = this._ParsePath(str)
			if (!path.length) return false
			const key = path.pop()
			const obj = this._GetValueAtFullPath(path, false)
			if (Array.isArray(obj)) {
				const index = parseInt(key, 10)
				return index >= 0 && index < obj.length
			} else if (typeof obj === "object" && obj !== null) return obj.hasOwnProperty(key)
			else return false
		}
		_SetValue(str, value) {
			const path = this._ParsePath(str)
			if (!path.length) {
				this._data = value
				return true
			}
			if (this._HasValueCache(path, true)) this._InvalidateValueCache()
			const key = path.pop()
			const obj = this._GetValueAtFullPath(path, true)
			//const obj = path.length ? this._GetValueAtFullPath(path, true) : this._data

			if (Array.isArray(obj)) {
				const index = parseInt(key, 10)
				if (!isFinite(index) || index < 0 || index >= obj.length) return false
				obj[index] = value
				return true
			} else if (typeof obj === "object" && obj !== null) {
				obj[key] = value
				return true
			}
			return false
		}
		_DeleteKey(str) {
			const path = this._ParsePath(str)
			if (!path.length) return false
			if (this._HasValueCache(path, true)) this._InvalidateValueCache()
			const key = path.pop()
			const obj = this._GetValueAtFullPath(path, false)
			if (Array.isArray(obj)) return false
			else if (typeof obj === "object" && obj !== null) {
				delete obj[key]
				return true
			} else return false
		}
		_saveToJson() {
			return {
				path: this._path,
				data: this._data
			}
		}
		_loadFromJson(o) {
			this._InvalidateValueCache()
			this._InvalidateLocationCache()
			this._path = o["path"]
			this._data = o["data"]
		}
		_SanitizeValue(val) {
			const type = typeof val
			if (type === "number") {
				if (!isFinite(val)) return 0
				return val
			}
			if (typeof val == "object") return JSON.stringify(val)
			return val + ""
		}
		_getDebuggerProperties() {
			const prefix = "plugins.json.debugger"
			let topLevelData
			try {
				topLevelData = this._SanitizeValue(this._data)
			} catch (e) {
				// eslint-disable-next-line quotes
				topLevelData = '"invalid"'
			}
			return [
				{
					title: prefix + ".title",
					properties: [
						{
							name: prefix + ".data",
							value: topLevelData,
							onedit: (v) => {
								try {
									const n = JSON.parse(v)
									this._SetData(n)
								} catch (e) {
									//
								}
							}
						},
						{
							name: prefix + ".path",
							value: this._path.map((seg) => seg.replace(/\./g, "\\.")).join(".")
						}
					]
				}
			]
		}

		//for each with sortedKeys array argument
		_ForEach(str, sortedKeys) {
			const value = this._GetValue(str)
			if (typeof value !== "object" || value === null) return false

			const loopCtx = this.runtime.sdk.createLoopingConditionContext();

			const oldPath = this._path
			const oldKey = this._currentKey
			const oldValue = this._currentValue
			const oldLoopindex = this._curLoopindex
			//console.log("Old loopindex", oldLoopindex)
			this._curLoopindex = -1
			const subPath = this._ParsePathUnsafe(str)
			//this.runtime.setDebuggingEnabled(false)

			// Loop through keys or sorted keys
			const keysToLoop = sortedKeys ? sortedKeys : Object.keys(value)

			for (const k of keysToLoop) {
				if (this._stopLoop) {
					//console.log("stop loop")
					this._stopLoop = false
					break
				}
				if (loopCtx.isStopped) break;

				this._path = C3.cloneArray(subPath)
				this._path.push(k)
				this._currentKey = k
				this._currentValue = value[k]
				this._curLoopindex++
				loopCtx.retrigger()
			}
			this._stopLoop = false
			//this.runtime.SetDebuggingEnabled(true)
			this._path = oldPath
			this._InvalidateLocationCache()
			this._currentKey = oldKey
			this._currentValue = oldValue
			this._curLoopindex = oldLoopindex
			loopCtx.release();
			return false
		}

		/*
		_SortFunction_ByValue(keyA, keyB) {
			var valA = self._GetSafeValueSort(str + "." + keyA + "." + subKey)
			var valB = self._GetSafeValueSort(str + "." + keyB + "." + subKey)
			var m = sortMode_

			if (sortMode_ >= 2) {
				// logical descending, logical ascending
				valA = parseFloat(valA)
				valB = parseFloat(valB)
				m -= 2
			}

			switch (m) {
				case 0: // descending
					if (valA === Infinity) valA = -Infinity
					if (valB === Infinity) valB = -Infinity
					if (valA === valB) return 0
					else if (valA < valB) return 1
					else return -1
					break

				case 1: // ascending
					if (valA === valB) return 0
					else if (valA > valB) return 1
					else return -1
					break
			}
		}*/

		_SortByValue(str, subKey, sortMode_) {
			//sort all keys in the object by the value of the subKey
			//sortMode_ 0 = descending, 1 = ascending, 2 = logical descending, 3 = logical ascending
			var object = this._GetValue(str)
			var keys = Object.keys(object)
			var self = this
			var sortFn = function (keyA, keyB) {
				var valA = self._GetSafeValueSort(str + "." + keyA + "." + subKey)
				var valB = self._GetSafeValueSort(str + "." + keyB + "." + subKey)
				var m = sortMode_

				if (sortMode_ >= 2) {
					// logical descending, logical ascending
					valA = parseFloat(valA)
					valB = parseFloat(valB)
					m -= 2
				}

				switch (m) {
					case 0: // descending
						if (valA === Infinity) valA = -Infinity
						if (valB === Infinity) valB = -Infinity
						if (valA === valB) return 0
						else if (valA < valB) return 1
						else return -1
						break

					case 1: // ascending
						if (valA === valB) return 0
						else if (valA > valB) return 1
						else return -1
						break
				}
			}
			keys.sort(sortFn)
			return keys
		}

		_SortByKey(str, subKey, sortMode_) {
			//sort all keys in the object by the value of the subKey
			//sortMode_ 0 = descending, 1 = ascending, 2 = logical descending, 3 = logical ascending
			var object = this._GetValue(str)
			var keys = Object.keys(object)
			var self = this
			var sortFn = function (keyA, keyB) {
				var valA = str + "." + keyA + "." + subKey
				var valB = str + "." + keyB + "." + subKey
				var m = sortMode_

				if (sortMode_ >= 2) {
					// logical descending, logical ascending
					valA = parseFloat(valA)
					valB = parseFloat(valB)
					m -= 2
				}

				switch (m) {
					case 0: // descending
						if (valA === Infinity) valA = -Infinity
						if (valB === Infinity) valB = -Infinity
						if (valA === valB) return 0
						else if (valA < valB) return 1
						else return -1
						break

					case 1: // ascending
						if (valA === valB) return 0
						else if (valA > valB) return 1
						else return -1
						break
				}
			}
			keys.sort(sortFn)
			return keys
		}

		_SortByMappingFunction(str, fnName, params, sortMode_) {
			//console.log("sort by mapping function", str, fnName, sortMode_)
			var object = this._GetValue(str)
			var keys = Object.keys(object)
			var self = this
			var sortFn = function (keyA, keyB) {
				var valA = self._CallMapFunction(fnName, params, str + "." + keyA)
				var valB = self._CallMapFunction(fnName, params, str + "." + keyB)
				var m = sortMode_

				if (sortMode_ >= 2) {
					// logical descending, logical ascending
					valA = parseFloat(valA)
					valB = parseFloat(valB)
					m -= 2
				}

				switch (m) {
					case 0: // descending
						if (valA === Infinity) valA = -Infinity
						if (valB === Infinity) valB = -Infinity
						if (valA === valB) return 0
						else if (valA < valB) return 1
						else return -1
						break

					case 1: // ascending
						if (valA === valB) return 0
						else if (valA > valB) return 1
						else return -1
						break
				}
			}
			keys.sort(sortFn)
			return keys
		}

		_Array_GetLastIndex(array) {
			return array.length - 1
		}

		_Array_IsEmpty(array) {
			return !(array.length > 0)
		}

		getJsonDataCopy() {
			const data = map.get(this)._GetData()
			return JSON.parse(JSON.stringify(data))
		}
		setJsonDataCopy(o) {
			try {
				const o2 = JSON.parse(JSON.stringify(o))
				map.get(this)._SetData(o2)
			} catch (err) {
				console.error("[JSON plugin] setJsonData: object is not valid JSON: ", err)
				throw err
			}
		}
		setJsonString(str) {
			if ("string" == typeof str) {
				const o = JSON.parse(str)
				map.get(this)._SetData(o)
			}
			else {
				console.error("[JSON plugin] setJsonString: string is not valid JSON: " , str)
			}

		}
		toCompactString() {
			return JSON.stringify(this._GetData())
		}
		toBeautifiedString() {
			return JSON.stringify(this._GetData(), null, 4)
		}

		//custom
		getJsonDataCopyAtPath(str) {
			const value = this._GetValue(str)
			return JSON.parse(JSON.stringify(value))
		}

		setValue(path, o) {
			try {
				const o2 = JSON.parse(JSON.stringify(o))
				this._SetValue(path, o2)
			} catch (err) {
				console.error("[JSON plugin] setJsonAtPath: object is not valid JSON: ", err)
				throw err
			}
		}
	}
}
