"use strict"
{
	const C3 = globalThis.C3;
	C3.Behaviors.Overboy_JSONb.Acts = {
		//==============================================================================

		//MAPING (Better Features) =======================================================

		SetMappingResult(val) {
			this.mappingResult = val
			//console.log(this.mappingResult)
		},

		//ARRAY (Better Features) =======================================================

		ArrayShuffle(entryKey, random_gen) {
			const parent = this._GetValue(entryKey)
			if (!Array.isArray(parent)) return

			var i = parent.length,
				j,
				temp,
				random_value
			if (i == 0) return
			while (--i) {
				random_value = random_gen == null ? Math.random() : random_gen.random()
				j = Math.floor(random_value * (i + 1))
				temp = parent[i]
				parent[i] = parent[j]
				parent[j] = temp
			}
		},

		//ArraySort(entryKey, sortKey, sortMode_)
		ArraySort(arrayPath, sortMode_) {
			const parent = this._GetValue(arrayPath)
			if (!Array.isArray(parent)) return

			/*
			if (sortKey === "") sortKey = null
			else sortKey = sortKey.split(".")*/

			const sortFn = function (itemA, itemB) {
				/*
				let valA = sortKey ? this.getValue(sortKey, itemA) : itemA
				let valB = sortKey ? this.getValue(sortKey, itemB) : itemB*/
				let valA = itemA
				let valB = itemB

				let sortOrder = sortMode_

				if (sortMode_ >= 2) {
					// logical descending, logical ascending
					valA = parseFloat(valA)
					valB = parseFloat(valB)

					sortOrder -= 2
				}

				switch (sortOrder) {
					case 0: // descending
						if (valA === valB) return 0
						else if (valA < valB) return 1
						else return -1
						break

					case 1: // ascending
						if (valA === valB) return 0
						else if (valA > valB) return 1
						else return -1
						break
				}
			}
			parent.sort(sortFn)
		},

		StopLoop() {
			this._stopLoop = true
		},

		ArrayMap(arrayPath, fnName, params) {
			const parent = this._GetValue(arrayPath)
			if (!Array.isArray(parent)) return

			const mappedArray = parent.map((key, index) => {
				const result = this._CallMapFunction(fnName, params, arrayPath + "." + index)
				//console.log(result)
				return result
			})

			this._SetValue(arrayPath, mappedArray)
		},

		ArraySortByMapping(arrayPath, fnName, sortMode_) {
			const parent = this._GetValue(arrayPath)
			if (!Array.isArray(parent)) return

			const sortFn = function (valA, valB) {
				var m = sortMode_

				if (sortMode_ >= 2) {
					// logical descending, logical ascending
					valA = parseFloat(valA)
					valB = parseFloat(valB)

					m -= 2
				}

				switch (m) {
					case 0: // descending
						if (valA === valB) return 0
						else if (valA < valB) return 1
						else return -1
						break

					case 1: // ascending
						if (valA === valB) return 0
						else if (valA > valB) return 1
						else return -1
						break
				}
			}
			parent.sort(sortFn)
		},

		ArrayFilterByMapping(arrayPath, fnName, params, cmp, value) {
			const parent = this._GetValue(arrayPath)
			if (!Array.isArray(parent)) return

			const filteredArray = parent.filter((key, index) => {
				return C3.compare(this._CallMapFunction(fnName, params, arrayPath + "." + index), cmp, value)
			})

			this._SetValue(arrayPath, filteredArray)
		},

		//==============================================================================

		Parse(str) {
			try {
				this._SetData(JSON.parse(str))
			} catch (err) {
				console.warn("[JSON behavior] Failed to parse JSON data: ", err)
				this._SetData({})
				this._trigger(C3.Behaviors.Overboy_JSONb.Cnds.OnParseError)
			}
		},
		SetPath(str) {
			this._SetPath(str)
		},
		SetValue(str, value) {
			this._SetValue(str, value)
		},
		SetArray(str, size) {
			let value = this._GetValue(str)
			if (Array.isArray(value)) C3.resizeArray(value, size, 0)
			else {
				value = []
				C3.extendArray(value, size, 0)
				this._SetValue(str, value)
			}
		},
		SetObject(str) {
			this._SetValue(str, {})
		},
		SetJSON(location, value) {
			let obj = null
			try {
				obj = JSON.parse(value)
			} catch (err) {
				console.warn("[JSON behavior] Failed to parse JSON data: ", err)
				this._trigger(C3.Behaviors.Overboy_JSONb.Cnds.OnParseError)
			}
			this._SetValue(location, obj)
		},
		SetNull(str) {
			this._SetValue(str, null)
		},
		SetBoolean(str, value) {
			this._SetValue(str, value !== 0)
		},
		ToggleBoolean(str) {
			const value = this._GetValue(str)
			if (typeof value === "boolean") this._SetValue(str, !value)
		},
		AddTo(str, inc) {
			const value = this._GetValue(str)
			if (typeof value === "number") this._SetValue(str, value + inc)
			else if (value === null) this._SetValue(str, inc)
		},
		SubtractFrom(str, dec) {
			const value = this._GetValue(str)
			if (typeof value === "number") this._SetValue(str, value - dec)
			else if (value === null) this._SetValue(str, -dec)
		},
		DeleteKey(str) {
			this._DeleteKey(str)
		},
		PushValue(side, str, value) {
			const parent = this._GetValue_CanCreateArray(str)
			if (Array.isArray(parent)) side === 0 ? parent.push(value) : parent.unshift(value)
		},
		PopValue(side, str) {
			const parent = this._GetValue(str)
			if (Array.isArray(parent)) side === 0 ? parent.pop() : parent.shift()
		},
		InsertValue(value, str, index) {
			const parent = this._GetValue(str)
			if (Array.isArray(parent)) parent.splice(index, 0, value)
		},
		RemoveValues(count, str, index) {
			const parent = this._GetValue(str)
			if (Array.isArray(parent)) parent.splice(index, count)
		},
		Log(text, path) {
			const result = JSON.parse(JSON.stringify(this._GetValue(path)))
			console.log(text, result)
			//console.log("%c" + text, "font-weight:bold", result)
		}
		/*,
		// TESTY :
		PushValue_CanCreateArray(side, str, value) {
			const parent = this._GetValue(str)
			if (parent === null) {
				this._SetValue(str, [])
			}
			if (Array.isArray(parent)) side === 0 ? parent.push(value) : parent.unshift(value)
		}*/
	}
}
