const C3 = globalThis.C3;

class EMI_INDO_DeepSeekAIInstance extends globalThis.ISDKInstanceBase
{
	

	constructor()
	{
		super();
		
		const properties = this._getInitProperties();
		if (properties)		
		{
			
        }

        this._responseData = "";
        this._errorMsg = "";
	}
	
	_release()
	{
		super._release();
	}

	_setTestProperty(n: number)
	{
		// this._testProperty = n;
	}

	_getTestProperty()
	{
		// return this._testProperty;
	}
	
	_saveToJson()
	{
		return {
			// data to be saved for savegames
		};
	}
	
	_loadFromJson(o: any)
	{
		// load state for savegames
    }

    _SendRequest(apiUrl: string, apiKey: string, prompt: string, maxTokens: any, temperature: any) {

        if (typeof (window as any).cordova !== 'undefined') {

            (window as any).cordova.plugins.CordovaDeepSeekPlugin.sendRequest({

                apiUrl: apiUrl, 
                apiKey: apiKey, 
                prompt: prompt,
                maxTokens: maxTokens, 
                temperature: temperature, 

            }, function (result: any) {

                this._responseData = (JSON.stringify(result));
                this._trigger(C3.Plugins.EMI_INDO_DeepSeekAI.Cnds.OnSuccess);

            
            }, function (error: any) {

                this._errorMsg = (JSON.stringify(error));
                this._trigger(C3.Plugins.EMI_INDO_DeepSeekAI.Cnds.OnError);

            })
            
        }
    }


    _SendRequestAdvanced(apiUrl: string, apiKey: string, model: string, role: string, content: string, maxTokens: any, temperature: any, top: any) {
        if (typeof (window as any).cordova !== 'undefined') {
            const token = parseInt(maxTokens);
            const temp = parseFloat(temperature);
            const tp = parseFloat(top);

            var options = {
                apiUrl: apiUrl,
                apiKey: apiKey,
                model: model,
                messages: [
                    { role: role, content: content }
                ],
                temperature: temp,
                max_tokens: token,
                top_p: tp
            };

            (window as any).cordova.plugins.CordovaDeepSeekPlugin.sendRequestAdvanced(options,
                function (response: any) {
                    this._responseData = JSON.parse(JSON.stringify(response, null, 2));
                    this._trigger(C3.Plugins.EMI_INDO_DeepSeekAI.Cnds.OnSuccess);
                }, function (error: any) {
                    this._errorMsg = (JSON.stringify(error));
                    this._trigger(C3.Plugins.EMI_INDO_DeepSeekAI.Cnds.OnError);
                });

        }
    }

    
};

C3.Plugins.EMI_INDO_DeepSeekAI.Instance = EMI_INDO_DeepSeekAIInstance;

export type { EMI_INDO_DeepSeekAIInstance as SDKInstanceClass };