"use strict";
{
    const SDK = globalThis.SDK;

    const BEHAVIOR_ID = "FedericoCalchera_TriggerTimer";
    const BEHAVIOR_CATEGORY = "general";

    const BEHAVIOR_CLASS = SDK.Behaviors.FedericoCalchera_TriggerTimer = class TriggerTimerBehavior extends SDK.IBehaviorBase
    {
        constructor()
        {
            super(BEHAVIOR_ID);

            SDK.Lang.PushContext("behaviors." + BEHAVIOR_ID.toLowerCase());

            this._info.SetName(globalThis.lang(".name"));
            this._info.SetDescription(globalThis.lang(".description"));
            this._info.SetCategory(BEHAVIOR_CATEGORY);
            this._info.SetAuthor("FedericoCalchera");
            this._info.SetHelpUrl(globalThis.lang(".help-url"));
            this._info.SetIsOnlyOneAllowed(true);
            this._info.SetCanBeBundled(true);

            this._info.SetSupportedRuntimes(["c3"]);

            SDK.Lang.PushContext(".properties");

            this._info.SetProperties([

            ]);

            SDK.Lang.PopContext(); //.properties
            SDK.Lang.PopContext();
        }
    };

    BEHAVIOR_CLASS.Register(BEHAVIOR_ID, BEHAVIOR_CLASS);
}