﻿%%FRAGMENTINPUT_STRUCT%%

%%FRAGMENTOUTPUT_STRUCT%%

%%SAMPLERFRONT_BINDING%% var samplerFront : sampler;
%%TEXTUREFRONT_BINDING%% var textureFront : texture_2d<f32>;

struct ShaderParams {
	intensity : f32,
};

%%SHADERPARAMS_BINDING%% var<uniform> shaderParams : ShaderParams;

%%C3PARAMS_STRUCT%%

%%C3_UTILITY_FUNCTIONS%%


@fragment
fn main(input : FragmentInput) -> FragmentOutput
{
	var uv: vec2<f32> = c3_srcOriginToNorm(input.fragUV);
	let depth: f32 = shaderParams.intensity * 5.;
	let distX: f32 = distance(uv.x, 0.5);
	let distY: f32 = distance(uv.y, 0.5);
	let offset: f32 = distY * 0.2 * distX;

	var dir: f32 = 1.;
	if (uv.x > 0.5) {dir = -1.;};

	let coords: vec2<f32> = vec2<f32>(uv.x + distY * (offset * depth * dir), uv.y);

	var output : FragmentOutput;
	output.color = textureSample(textureFront, samplerFront, c3_normToSrcOrigin(coords));
	return output;
}