varying mediump vec2 vTex;
uniform lowp sampler2D samplerFront;
uniform mediump vec2 srcOriginStart;
uniform mediump vec2 srcOriginEnd;

uniform mediump float intensity;

precision mediump float;

void main(void)
{  
    mediump vec2 srcOriginSize = srcOriginEnd - srcOriginStart;
    mediump vec2 uv = ((vTex - srcOriginStart) / srcOriginSize);
    
    float depth = intensity * 5.;
    float distX = distance(uv.x, .5);
    float distY = distance(uv.y, .5);  
    float offset = distY * .2 * distX;

    float dir = 1.;
    if (uv.x > 0.5) dir = -1.;
    
    vec2 coords = vec2(uv.x + distY * (offset * depth * dir), uv.y);

    gl_FragColor = texture2D(samplerFront, coords * srcOriginSize + srcOriginStart); 
}