const SDK = self.SDK;

const PLUGIN_INFO = {
    ...{
  "id": "skymen_mask",
  "version": "1.0.0.10",
  "category": "general",
  "author": "reddog, skymen",
  "addonType": "plugin",
  "info": {
    "defaultImageUrl": null,
    "Set": {
      "IsResizable": true,
      "IsRotatable": false,
      "Is3D": false,
      "HasImage": false,
      "IsTiled": false,
      "SupportsZElevation": false,
      "SupportsColor": false,
      "SupportsEffects": false,
      "MustPreDraw": false,
      "IsSingleGlobal": false,
      "CanBeBundled": true,
      "IsDeprecated": false,
      "GooglePlayServicesEnabled": false
    },
    "AddCommonACEs": {
      "Position": true,
      "SceneGraph": true,
      "Size": true,
      "Angle": false,
      "Appearance": true,
      "ZOrder": true
    }
  },
  "domSideScripts": [],
  "fileDependencies": [],
  "type": "world"
},
    properties: [
      {
            type: "check",
            id: "start",
            options: {
              ...{
  "initialValue": true
},
              
              
              
            },
          },
{
            type: "check",
            id: "visible",
            options: {
              ...{
  "initialValue": true
},
              
              
              
            },
          },
{
            type: "float",
            id: "hotspot-x",
            options: {
              ...{
  "initialValue": 0,
  "interpolatable": false
},
              
              
              
            },
          },
{
            type: "float",
            id: "hotspot-y",
            options: {
              ...{
  "initialValue": 0,
  "interpolatable": false
},
              
              
              
            },
          }
    ],
  };

let app = null;

SDK.Plugins[PLUGIN_INFO.id] = class extends SDK.IPluginBase {
  constructor() {
    super(PLUGIN_INFO.id);
    SDK.Lang.PushContext("plugins." + PLUGIN_INFO.id.toLowerCase());
    this._info.SetName(self.lang(".name"));
    this._info.SetDescription(self.lang(".description"));
    this._info.SetVersion(PLUGIN_INFO.version);
    this._info.SetCategory(PLUGIN_INFO.category);
    this._info.SetAuthor(PLUGIN_INFO.author);
    this._info.SetPluginType(
      PLUGIN_INFO.type === "object" ? "object" : "world"
    );
    this._info.SetHelpUrl(self.lang(".help-url"));
    if (PLUGIN_INFO.icon) {
      this._info.SetIcon(
        PLUGIN_INFO.icon,
        PLUGIN_INFO.icon.endsWith(".svg") ? "image/svg+xml" : "image/png"
      );
    }

    if (PLUGIN_INFO.defaultImageUrl) {
      this._info.SetDefaultImageURL(`c3runtime/${PLUGIN_INFO.defaultImageUrl}`);
    }

    if (PLUGIN_INFO.domSideScripts) {
      this._info.SetDOMSideScripts(
        PLUGIN_INFO.domSideScripts.map((s) => `c3runtime/${s}`)
      );
    }

    if (PLUGIN_INFO.fileDependencies) {
      PLUGIN_INFO.fileDependencies.forEach((file) => {
        this._info.AddFileDependency({
          ...file,
          filename: `c3runtime/${file.filename}`,
        });
      });
    }

    if (PLUGIN_INFO.info && PLUGIN_INFO.info.Set)
      Object.keys(PLUGIN_INFO.info.Set).forEach((key) => {
        const value = PLUGIN_INFO.info.Set[key];
        const fn = this._info[`Set${key}`];
        if (fn && value !== null && value !== undefined)
          fn.call(this._info, value);
      });
    if (PLUGIN_INFO.info && PLUGIN_INFO.info.AddCommonACEs)
      Object.keys(PLUGIN_INFO.info.AddCommonACEs).forEach((key) => {
        if (PLUGIN_INFO.info.AddCommonACEs[key])
          this._info[`AddCommon${key}ACEs`]();
      });
    SDK.Lang.PushContext(".properties");
    this._info.SetProperties(
      (PLUGIN_INFO.properties || []).map(
        (prop) => new SDK.PluginProperty(prop.type, prop.id, prop.options)
      )
    );
    SDK.Lang.PopContext(); // .properties
    SDK.Lang.PopContext();
  }
};
const P_C = SDK.Plugins[PLUGIN_INFO.id];
P_C.Register(PLUGIN_INFO.id, P_C);

P_C.Type = class extends SDK.ITypeBase {
  constructor(sdkPlugin, iObjectType) {
    super(sdkPlugin, iObjectType);
  }
};

const instanceParentClasses = {
  object: SDK.IInstanceBase,
  world: SDK.IWorldInstanceBase,
  dom: SDK.IWorldInstanceBase,
};
P_C.Instance = class extends instanceParentClasses[PLUGIN_INFO.type] {
  constructor(sdkType, inst) {
    super(sdkType, inst);
  }

  Draw(iRenderer, iDrawParams) {
    // draw a box with line width 4
    iRenderer.SetColorFillMode();
    iRenderer.SetColor(this._inst.GetColor());
    iRenderer.PushLineWidth(2);
    iRenderer.PushLineCap("square");
    iRenderer.LineQuad(this._inst.GetQuad());
    iRenderer.PopLineWidth();
    iRenderer.PopLineCap();
  }

  Release() {}

  OnCreate() {
    this.UpdateOrigin();
  }

  OnPlacedInLayout() {}

  IsOriginalSizeKnown() {
    return false;
  }

  HasDoubleTapHandler() {
    return false;
  }

  UpdateOrigin() {
    this._inst.SetOrigin(
      this._inst.GetPropertyValue("hotspot-x"),
      this._inst.GetPropertyValue("hotspot-y")
    );
  }

  OnPropertyChanged(id, value) {
    // handle hotspot-x and hotspot-y properties
    if (id === "hotspot-x" || id === "hotspot-y") {
      this.UpdateOrigin();
    }
  }

  LoadC2Property(name, valueString) {
    return false; // not handled
  }
};
