﻿%%SAMPLERFRONT_BINDING%% var samplerFront : sampler;
%%TEXTUREFRONT_BINDING%% var textureFront : texture_2d<f32>;

struct ShaderParams {
    redx : f32,
    greenx : f32,
    bluex : f32,
    alphax : f32,
    redy : f32,
    greeny : f32,
    bluey : f32,
    alphay : f32,
    intensity : f32,
    innerDecrease : f32
};
%%SHADERPARAMS_BINDING%% var<uniform> shaderParams : ShaderParams;

%%FRAGMENTINPUT_STRUCT%%

%%FRAGMENTOUTPUT_STRUCT%%

%%C3PARAMS_STRUCT%%

%%C3_UTILITY_FUNCTIONS%%

@fragment
fn main(input : FragmentInput) -> FragmentOutput
{
    var front : vec4<f32> = textureSample(textureFront, samplerFront, input.fragUV);
    var color : vec4<f32> = front;
    var pixelSize : vec2<f32> = c3_getPixelSize(textureFront);
    

    var edgeFactor : f32 = select(distance(vec2(0.5), c3_srcOriginToNorm(input.fragUV)) * shaderParams.innerDecrease * 2., 1., shaderParams.innerDecrease == 0.);

    color.r = textureSample(textureFront,samplerFront, input.fragUV - vec2<f32>(shaderParams.redx, shaderParams.redy) * pixelSize * edgeFactor).r;
    color.g = textureSample(textureFront,samplerFront, input.fragUV - vec2<f32>(shaderParams.greenx, shaderParams.greeny) * pixelSize * edgeFactor).g;
    color.b = textureSample(textureFront,samplerFront, input.fragUV - vec2<f32>(shaderParams.bluex, shaderParams.bluey) * pixelSize * edgeFactor).b;
    color.a = textureSample(textureFront,samplerFront, input.fragUV - vec2<f32>(shaderParams.alphax, shaderParams.alphay) * pixelSize * edgeFactor).a;

    var output : FragmentOutput;
	output.color = mix(front, color, shaderParams.intensity);
	return output;
}
