﻿#version 300 es

precision mediump float;

in vec2 vTex;
out vec4 fragColor;
uniform sampler2D samplerFront;
uniform vec2 pixelSize;
uniform vec2 srcOriginStart;
uniform vec2 srcOriginEnd;

uniform float redx;
uniform float redy;
uniform float bluex;
uniform float bluey;
uniform float greenx;
uniform float greeny;
uniform float alphax;
uniform float alphay;
uniform float intensity;
uniform float innerDecrease;


void main(void)
{
    vec2 srcOriginSize = srcOriginEnd - srcOriginStart;
    vec2 n = ((vTex - srcOriginStart) / srcOriginSize);

   float edgeFactor = innerDecrease == 0. ? 1. : distance(vec2(0.5), n) * innerDecrease * 2.;

    vec4 front = texture(samplerFront, vTex);
    vec4 color = front;

    color.r = texture(samplerFront, vTex - vec2(redx, redy) * pixelSize * edgeFactor).r;
	color.g = texture(samplerFront, vTex - vec2(greenx, greeny) * pixelSize * edgeFactor).g;
	color.b = texture(samplerFront, vTex - vec2(bluex, bluey) * pixelSize * edgeFactor).b;
	color.a = texture(samplerFront, vTex - vec2(alphax, alphay) * pixelSize * edgeFactor).a;

    fragColor = mix(front, color, intensity);
}
