﻿////////////////////////////////////////////////////////////////////////////
// RGBA-channel separation
// Many thanks to David Clark who wrote this shader for Construct Classic
// Original Construct 2 effect 'RGBA channel separation' by Jan Raap a.k.a. oppenheimer
// Ported to Construct 3 by Jeremy Lonien aka Ludonaut
////////////////////////////////////////////////////////////////////////////

precision mediump float;

varying mediump vec2 vTex;
uniform lowp sampler2D samplerFront;
uniform vec2 pixelSize;
uniform vec2 srcOriginStart;
uniform vec2 srcOriginEnd;

uniform float redx;
uniform float redy;
uniform float bluex;
uniform float bluey;
uniform float greenx;
uniform float greeny;
uniform float alphax;
uniform float alphay;
uniform float intensity;
uniform float innerDecrease;

void main(void)
{
	vec2 srcOriginSize = srcOriginEnd - srcOriginStart;
    vec2 n = ((vTex - srcOriginStart) / srcOriginSize);

	float edgeFactor = innerDecrease == 0. ? 1. : distance(vec2(0.5), n) * innerDecrease * 2.;

	vec4 front = texture2D(samplerFront, vTex); 
	vec4 color = front; 
	

	color.r = texture2D(samplerFront, vTex - vec2(redx, redy) * pixelSize * edgeFactor).r;
	color.g = texture2D(samplerFront, vTex - vec2(greenx, greeny) * pixelSize * edgeFactor).g;
	color.b = texture2D(samplerFront, vTex - vec2(bluex, bluey) * pixelSize * edgeFactor).b;
	color.a = texture2D(samplerFront, vTex - vec2(alphax, alphay) * pixelSize * edgeFactor).a;
	
	gl_FragColor = mix(front, color, intensity);
}