"use strict";
{
    const SDK = globalThis.SDK;

    const BEHAVIOR_ID = "FedericoCalchera_HP";
    const BEHAVIOR_CATEGORY = "general";

    const BEHAVIOR_CLASS = SDK.Behaviors.FedericoCalchera_HP = class HPBehavior extends SDK.IBehaviorBase
    {
        constructor()
        {
            super(BEHAVIOR_ID);

            SDK.Lang.PushContext("behaviors." + BEHAVIOR_ID.toLowerCase());

            this._info.SetName(lang(".name"));
            this._info.SetDescription(lang(".description"));
            this._info.SetCategory(BEHAVIOR_CATEGORY);
            this._info.SetAuthor("FedericoCalchera");
            this._info.SetHelpUrl(lang(".help-url"));
            this._info.SetIsOnlyOneAllowed(false);
            this._info.SetCanBeBundled(true);

            this._info.SetSupportedRuntimes(["c3"]);

            SDK.Lang.PushContext(".properties");

            this._info.SetProperties([
                new SDK.PluginProperty("float", "maxHP", 3,
            {
                "interpolatable": false
            }),
                new SDK.PluginProperty("check", "isEnabled", true,
            {
                "interpolatable": false
            })
            ]);

            SDK.Lang.PopContext(); //.properties
            SDK.Lang.PopContext();
        }
    };

    BEHAVIOR_CLASS.Register(BEHAVIOR_ID, BEHAVIOR_CLASS);
}