﻿%%FRAGMENTINPUT_STRUCT%%

%%FRAGMENTOUTPUT_STRUCT%%

%%SAMPLERFRONT_BINDING%% var samplerFront : sampler;
%%TEXTUREFRONT_BINDING%% var textureFront : texture_2d<f32>;

struct ShaderParams {
	waves : f32,
	amplitude : f32,
	time : f32
};

%%SHADERPARAMS_BINDING%% var<uniform> shaderParams : ShaderParams;

%%C3PARAMS_STRUCT%%

%%C3_UTILITY_FUNCTIONS%%


@fragment
fn main(input : FragmentInput) -> FragmentOutput
{
	let pixelSize : vec2<f32> = c3_getPixelSize(textureFront);

	var tex: vec2<f32> = input.fragUV;
	tex.y = tex.y + (sin((c3Params.seconds / (shaderParams.time * 0.5) - tex.x) * shaderParams.waves * 3.14) * tex.x * shaderParams.amplitude * pixelSize.x);

	var output : FragmentOutput;
	output.color = textureSample(textureFront, samplerFront, tex);
	return output;
}