﻿%%FRAGMENTINPUT_STRUCT%%

%%FRAGMENTOUTPUT_STRUCT%%

%%SAMPLERFRONT_BINDING%% var samplerFront : sampler;
%%TEXTUREFRONT_BINDING%% var textureFront : texture_2d<f32>;

//%//%SAMPLERBACK_BINDING%//% var samplerBack : sampler;
//%//%TEXTUREBACK_BINDING%//% var textureBack : texture_2d<f32>;

//%//%SAMPLERDEPTH_BINDING%//% var samplerDepth : sampler;
//%//%TEXTUREDEPTH_BINDING%//% var textureDepth : texture_depth_2d;

struct ShaderParams {
	inner : f32,
	outer : f32,
	strength : f32,
	curvature : f32,
	vignetteColor : vec3<f32>,
	
};
%%SHADERPARAMS_BINDING%% var<uniform> shaderParams : ShaderParams;


%%C3PARAMS_STRUCT%%


%%C3_UTILITY_FUNCTIONS%%

@fragment
fn main(input : FragmentInput) -> FragmentOutput
{
	let front: vec4<f32> = textureSample(textureFront, samplerFront, input.fragUV);;
	var uv: vec2<f32> = c3_srcOriginToNorm(input.fragUV);

	let curve: vec2<f32> = pow(abs(uv * 2. - 1.), vec2<f32>(1. / shaderParams.curvature));
	let edge: f32 = pow(length(curve), shaderParams.curvature);
	let vignette: f32 = shaderParams.strength * smoothstep(shaderParams.inner, shaderParams.outer, edge);
	
	var output : FragmentOutput;
	output.color = mix(front, vec4<f32>(shaderParams.vignetteColor, 1.), vignette);
	return output;
}
