uniform mediump float inner;
uniform mediump float outer;
uniform mediump float strength;
uniform mediump float curvature;
uniform lowp vec3 vignetteColor;
varying mediump vec2 vTex;
uniform lowp sampler2D samplerFront;
uniform mediump vec2 srcOriginStart;
uniform mediump vec2 srcOriginEnd;
precision mediump float;


void main(void)
{
    mediump vec2 srcOriginSize = srcOriginEnd - srcOriginStart;
    mediump vec2 uv = ((vTex - srcOriginStart) / srcOriginSize);
    vec4 front = texture2D(samplerFront, vTex);
    
    //Calculate edge curvature
    vec2 curve = pow(abs(uv * 2. - 1.), vec2(1. / curvature));
    //Compute distance to edge
    float edge = pow(length(curve), curvature);
    //Compute vignette gradient and intensity
    float vignette = strength * smoothstep(inner, outer, edge);
    
    gl_FragColor = mix(front, vec4(vignetteColor, 1.), vignette);
}