﻿
%%FRAGMENTINPUT_STRUCT%%

%%FRAGMENTOUTPUT_STRUCT%%

%%SAMPLERFRONT_BINDING%% var samplerFront : sampler;
%%TEXTUREFRONT_BINDING%% var textureFront : texture_2d<f32>;

struct ShaderParams {
	kernel : f32,
	brightness : f32,
	threshold : f32,
	lowThreshold : f32
	
};
%%SHADERPARAMS_BINDING%% var<uniform> shaderParams : ShaderParams;

%%C3PARAMS_STRUCT%%

%%C3_UTILITY_FUNCTIONS%%

var weight: f32 = 0.;

fn luminance(rgb: vec3<f32>) -> f32 {
	let W: vec3<f32> = vec3<f32>(0.2125, 0.7154, 0.0721);
	return dot(rgb, W);
} 

fn bloom(samp: vec4<f32>) -> vec4<f32> {
	lum: f32= luminance(samp.rgb);
    weight = weight + lum;
	return smoothstep(shaderParams.lowThreshold , shaderParams.threshold , lum) * samp;
} 

@fragment
fn main(input : FragmentInput) -> FragmentOutput
{
	var pixelSize : f32 = c3_getPixelSize(textureFront).x;
	var i : f32 = shaderParams.kernel;
	var front = textureSample(textureFront, samplerFront, input.fragUV);

	var col: vec4<f32> = bloom(textureSample(textureFront, samplerFront, input.fragUV + vec2<f32>(i, i) * pixelSize));
	col = col + bloom(textureSample(textureFront, samplerFront, input.fragUV + vec2<f32>(i, -i) * pixelSize));
	col = col + bloom(textureSample(textureFront, samplerFront, input.fragUV + vec2<f32>(-i, i) * pixelSize));
	col = col + bloom(textureSample(textureFront, samplerFront, input.fragUV + vec2<f32>(-i, -i) * pixelSize));
	col = col/weight;

	var output : FragmentOutput;
	output.color = col * shaderParams.brightness + front;
	return output;
}
