#version 300 es
uniform mediump float kernel;
uniform mediump float brightness;
uniform mediump float threshold;
uniform mediump float lowThreshold;
in mediump vec2 vTex;
uniform lowp sampler2D samplerFront;
uniform mediump vec2 pixelSize;
out lowp vec4 outColor;
precision mediump float;
mediump float weight = 0.;

mediump float luminance(vec3 rgb)
{
    const mediump vec3 W = vec3(0.2125, 0.7154, 0.0721);
    return dot(rgb, W);
}

mediump vec4 bloom(vec4 samp)
{  
    mediump float lum = luminance(samp.rgb);
    weight += lum;
    return smoothstep(lowThreshold , threshold , lum) * samp;
}

void main(void)
{
    mediump float i = kernel;  
    lowp vec4 front = texture(samplerFront, vTex);
    
    vec4 col = bloom(texture( samplerFront, vTex + vec2( i, i ) *pixelSize ));
    col += bloom(texture( samplerFront, vTex + vec2( i, -i ) *pixelSize ));
    col += bloom(texture( samplerFront, vTex + vec2( -i, i ) *pixelSize ));
    col += bloom(texture( samplerFront, vTex + vec2( -i, -i ) *pixelSize ));
    col /= weight;

    outColor = col * brightness + front;
}