﻿%%FRAGMENTINPUT_STRUCT%%

%%FRAGMENTOUTPUT_STRUCT%%

%%SAMPLERFRONT_BINDING%% var samplerFront : sampler;
%%TEXTUREFRONT_BINDING%% var textureFront : texture_2d<f32>;


struct ShaderParams {
	kernel : f32,
};

%%SHADERPARAMS_BINDING%% var<uniform> shaderParams : ShaderParams;

%%C3PARAMS_STRUCT%%

%%C3_UTILITY_FUNCTIONS%%

@fragment
fn main(input : FragmentInput) -> FragmentOutput
{
	var pixelSize : vec2<f32> = c3_getPixelSize(textureFront);

	var kernel2: f32 = shaderParams.kernel;

	var accumulation: vec4<f32> = vec4<f32>(0.);
	var weightsum: f32 = 0.;

	for (var i: f32 = -kernel2; i <= kernel2; i = i + 1) {
		accumulation += textureSample(textureFront, samplerFront, vec2<f32>(i * pixelSize.x, 0.) + input.fragUV);
		weightsum += 1.;
		}

	var output : FragmentOutput;
	output.color = accumulation / weightsum;
	return output;
}
