#version 300 es

uniform mediump float kernel;
in mediump vec2 vTex;
out lowp vec4 outColor;
uniform lowp sampler2D samplerFront;
uniform mediump vec2 pixelSize;

void main()
{	
    lowp vec4 accumulation = vec4(0.);
    mediump float weightsum = 0.;

    for (mediump float i = -kernel; i <= kernel; i++){
        accumulation += texture(samplerFront, vec2(i * pixelSize.x, 0.) + vTex);
        weightsum += 1.;
    }
    
    outColor = accumulation / weightsum;
}