uniform mediump float kernel;
varying mediump vec2 vTex;
uniform lowp sampler2D samplerFront;
uniform mediump vec2 pixelSize;

void main()
{
    mediump float kernel2 = min(kernel, 64.);
	
    lowp vec4 accumulation = vec4(0.);
    mediump float weightsum = 0.;

    for (mediump float i = 0.; i <= 128.; i++){
        accumulation += texture2D(samplerFront, vec2((i - kernel2)* pixelSize.x, 0.) + vTex);
        weightsum += 1.;
        if(i - kernel2 >= kernel2){
        break;
        }
    }
    
    gl_FragColor = accumulation / weightsum;
}