#version 300 es

uniform mediump float kernel;
in mediump vec2 vTex;
out lowp vec4 outColor;
uniform lowp sampler2D samplerFront;
uniform mediump vec2 pixelSize;
precision lowp float;

void main()
{
    mediump float kernel2 = min(kernel, 64.0);
    lowp vec4 front = texture(samplerFront, vTex);
	vec4 sum = vec4(0);
	
    vec4 accumulation = vec4(0);
    vec4 weightsum = vec4(0);
    for (float i = -kernel2; i <= kernel2; i++){
        accumulation += texture(samplerFront, vTex + vec2(i * pixelSize.x, 0.0)).rgba;
        weightsum += 1.0;
    }
    sum = accumulation / weightsum;
    
    outColor = vec4(sum);
}