uniform mediump float kernel;
varying mediump vec2 vTex;
uniform lowp sampler2D samplerFront;
uniform mediump vec2 pixelSize;
precision lowp float;

void main()
{
    mediump float kernel2 = min(kernel, 64.0);
    lowp vec4 front = texture2D(samplerFront, vTex);
	vec4 sum = vec4(0);
	
    vec4 accumulation = vec4(0);
    vec4 weightsum = vec4(0);
    for (float i = 0.0; i <= 128.0; i++){
        accumulation += texture2D(samplerFront, vTex + vec2((i - kernel2)* pixelSize.x, 0.0)).rgba;
        weightsum += 1.0;
         if(i - kernel2 >= kernel2){
        break;
    }
    }
    sum = accumulation / weightsum;
    
    gl_FragColor = vec4(sum);
}